<?php
session_start();

// Yüklenen araçların verilerini saklamak için JSON dosyası
$json_file = 'araclar.json';

// Mevcut araç verilerini JSON dosyasından al
$vehicles = [];
if (file_exists($json_file)) {
    $vehicles = json_decode(file_get_contents($json_file), true);
}

// Kayıt formunu işleyin
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Resim yükleme işlemi
    if (isset($_FILES['resim']) && $_FILES['resim']['error'] == UPLOAD_ERR_OK) {
        $uploads_dir = 'galeri'; // Yükleme dizini
        $tmp_name = $_FILES['resim']['tmp_name'];
        $name = basename($_FILES['resim']['name']);
        
        // Resmi yükle
        move_uploaded_file($tmp_name, "$uploads_dir/$name");

        // Araç verilerini diziye ekle
        $vehicles[] = [
            'resim' => $name,
            'marka' => $_POST['marka'],
            'model' => $_POST['model'],
            'yıl' => $_POST['yıl'],
            'yakıt_türü' => $_POST['yakıt_türü'],
            'kişi_sayısı' => $_POST['kişi_sayısı'],
            'günlük' => $_POST['günlük'],
            'aylık' => $_POST['aylık'],
            'vites' => $_POST['vites']
        ];

        // Güncellenen araç verilerini JSON dosyasına kaydet
        file_put_contents($json_file, json_encode($vehicles));

        // İşlem mesajını oturuma kaydet
        $_SESSION['message'] = 'Araç başarıyla eklendi!';
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }
}

// Silme işlemi
if (isset($_GET['sil'])) {
    $index = $_GET['sil'];
    unset($vehicles[$index]);
    $vehicles = array_values($vehicles); // Diziyi yeniden indeksle

    // Güncellenen araç verilerini JSON dosyasına kaydet
    file_put_contents($json_file, json_encode($vehicles));

    // İşlem mesajını oturuma kaydet
    $_SESSION['message'] = 'Araç başarıyla silindi!';
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Araç Kayıt Ekle</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>

<div class="container">
    <h1 class="mt-4">Araç Kayıt Ekle</h1>

    <!-- İşlem mesajını göster -->
    <?php if (isset($_SESSION['message'])): ?>
        <div class="alert alert-success">
            <?= $_SESSION['message'] ?>
            <?php unset($_SESSION['message']); // Mesajı gösterdikten sonra sil ?>
        </div>
    <?php endif; ?>

    <form action="" method="POST" enctype="multipart/form-data">
        <div class="form-group">
            <label for="resim">Araç Resmi</label>
            <input type="file" name="resim" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="marka">Marka</label>
            <input type="text" name="marka" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="model">Model</label>
            <input type="text" name="model" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="yıl">Yıl</label>
            <input type="number" name="yıl" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="yakıt_türü">Yakıt Türü</label>
            <select name="yakıt_türü" class="form-control" required>
                <option value="">Yakıt Türü Seçiniz</option>
                <option value="Benzin">Benzin</option>
                <option value="Dizel">Dizel</option>
                <option value="Elektrik">Elektrik</option>
                <option value="Hibrit">Hibrit</option>
            </select>
        </div>
        <div class="form-group">
            <label for="kişi_sayısı">Kişi Sayısı</label>
            <input type="number" name="kişi_sayısı" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="günlük">Günlük Kiralama Ücreti</label>
            <input type="number" name="günlük" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="aylık">Aylık Kiralama Ücreti</label>
            <input type="number" name="aylık" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="vites">Vites</label>
            <select name="vites" required class="form-control">
                <option value="">Vites Türü Seçiniz</option>
                <option value="Otomatik">Otomatik</option>
                <option value="Manuel">Manuel</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
    </form>

    <h2 class="mt-4">Araç Listesi</h2>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Resim</th>
                <th>Marka</th>
                <th>Model</th>
                <th>Yıl</th>
                <th>Yakıt Türü</th>
                <th>Kişi Sayısı</th>
                <th>Günlük Ücret</th>
                <th>Aylık Ücret</th>
                <th>Vites</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($vehicles as $index => $vehicle): ?>
                <tr>
                    <td><img src="galeri/<?= htmlspecialchars($vehicle['resim']) ?>" alt="Araç Resmi" width="100"></td>
                    <td><?= htmlspecialchars($vehicle['marka']) ?></td>
                    <td><?= htmlspecialchars($vehicle['model']) ?></td>
                    <td><?= htmlspecialchars($vehicle['yıl']) ?></td>
                    <td><?= htmlspecialchars($vehicle['yakıt_türü']) ?></td>
                    <td><?= htmlspecialchars($vehicle['kişi_sayısı']) ?></td>
                    <td><?= htmlspecialchars(number_format($vehicle['günlük'], 2, ',', '.')) ?> TL</td>
                    <td><?= htmlspecialchars(number_format($vehicle['aylık'], 2, ',', '.')) ?> TL</td>
                    <td><?= htmlspecialchars($vehicle['vites']) ?></td>
                    <td><a href="?sil=<?= $index ?>" class="btn btn-danger">Sil</a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
